// Pom1 Apple 1 Emulator
// Copyright (C) 2000 Verhille Arnaud
// Copyright (C) 2006 John D. Corrado
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

#include <SDL.h>
#include <stdio.h>
#include <string.h>
#include "memory.h"
#include "screen.h"
#include "options.h"

static SDL_Rect rect;
static int step, max, start;
static char filename[1024], buffer[1024], type, strAddress[5], strValue[3];
static FILE *fd = NULL;	

static void drawString(const char *str)
{
	int i = 0;
	int x = 0;

	while (str[i])
	{
		drawCharacter(x, 192 * getPixelSize() - 16 * getPixelSize(), 0, 0, 0, str[i++]);
		x += 7 * getPixelSize();
	}

}

static void inputLoop(const char *str, int (*func)(void))
{
	SDL_Event event;
	int i, c = 0, x = 0;
	char tmp;

	rect.x = 0;
	rect.y = 192 * getPixelSize() - 17 * getPixelSize();
	rect.w = 280 * getPixelSize();
	rect.h = 17 * getPixelSize();

	SDL_FillRect(SDL_GetVideoSurface(), &rect, 255);

	drawString(str);

	drawCharacter(x, 192 * getPixelSize() - 8 * getPixelSize(), 0, 0, 0, 0x01);

	step = 1;

	while (1)
	{
		while (SDL_PollEvent(&event))
		{
			if (event.type == SDL_KEYDOWN)
			{
				if (event.key.keysym.sym == SDLK_ESCAPE)
				{
					if (fd)
					{
						fclose(fd);
						fd = NULL;
					}

					updateScreen();

					return;
				}
				else if (event.key.keysym.sym == SDLK_SPACE)
				{
					if (c < max)
						buffer[c++] = ' ';
					else
						continue;

					rect.x = x;
					rect.y = 192 * getPixelSize() - 8 * getPixelSize();
					rect.w = 7 * getPixelSize();
					rect.h = 8 * getPixelSize();

					SDL_FillRect(SDL_GetVideoSurface(), &rect, 255);

					if (x < 39 * 7 * getPixelSize())
						x += 7 * getPixelSize();
					else
					{
						rect.x = 0;
						rect.y = 192 * getPixelSize() - 8 * getPixelSize();
						rect.w = 280 * getPixelSize() - 7 * getPixelSize();
						rect.h = 8 * getPixelSize();

						SDL_FillRect(SDL_GetVideoSurface(), &rect, 255);

						for (i = 0; i < 39 * getPixelSize() * getPixelSize(); ++i)
						{
							if (buffer[(c - 39) + i] == ' ')
							{
								rect.x = 7 * getPixelSize() * i;
								rect.y = 192 * getPixelSize() - 8 * getPixelSize();
								rect.w = 7 * getPixelSize();
								rect.h = 8 * getPixelSize();

								SDL_FillRect(SDL_GetVideoSurface(), &rect, 255);
							}
							else
								drawCharacter(7 * getPixelSize() * i, 192 * getPixelSize() - 8 * getPixelSize(), 0, 0, 0, buffer[(c - 39) + i]);
						}
					}

					drawCharacter(x, 192 * getPixelSize() - 8 * getPixelSize(), 0, 0, 0, 0x01);
				}
				else if (event.key.keysym.sym == SDLK_BACKSPACE)
				{
					if (c > 0)
						buffer[--c] = '\0';
					else
						continue;

					rect.x = x - 7 * getPixelSize();
					rect.y = 192 * getPixelSize() - 8 * getPixelSize();
					rect.w = 14 * getPixelSize();
					rect.h = 8 * getPixelSize();

					SDL_FillRect(SDL_GetVideoSurface(), &rect, 255);

					if (x > 0 && c < 39)
						x -= 7 * getPixelSize();
					else
					{
						rect.x = 0;
						rect.y = 192 * getPixelSize() - 8 * getPixelSize();
						rect.w = 280 * getPixelSize();
						rect.h = 8 * getPixelSize();

						SDL_FillRect(SDL_GetVideoSurface(), &rect, 255);

						for (i = 0; i < 39 * getPixelSize() * getPixelSize(); ++i)
						{
							if (buffer[(c - 39) + i] == ' ')
							{
								rect.x = 7 * i;
								rect.y = 192 * getPixelSize() - 8 * getPixelSize();
								rect.w = 7 * getPixelSize();
								rect.h = 8 * getPixelSize();

								SDL_FillRect(SDL_GetVideoSurface(), &rect, 255);
							}
							else
								drawCharacter(7 * getPixelSize() * i, 192 * getPixelSize() - 8 * getPixelSize(), 0, 0, 0, buffer[(c - 39) + i]);
						}
					}

					drawCharacter(x, 192 * getPixelSize() - 8 * getPixelSize(), 0, 0, 0, 0x01);
				}
				else if (event.key.keysym.sym == SDLK_RETURN)
				{
					rect.x = 0;
					rect.y = 192 * getPixelSize() - 17 * getPixelSize();
					rect.w = 280 * getPixelSize();
					rect.h = 17 * getPixelSize();

					SDL_FillRect(SDL_GetVideoSurface(), &rect, 255);

					buffer[c] = '\0';

					if (!(*func)())
					{
						if (fd)
						{
							fclose(fd);
							fd = NULL;
						}

						updateScreen();

						return;
					}

					c = x = 0;

					step++;
				}
				else if (!(event.key.keysym.unicode & 0xFF80))
				{
					tmp = event.key.keysym.unicode & 0x7F;

					if (c < max && tmp >= 0x21 && tmp <= 0x7E)
							buffer[c++] = tmp;
					else
						continue;

					rect.x = x;
					rect.y = 192 * getPixelSize() - 8 * getPixelSize();
					rect.w = 7 * getPixelSize();
					rect.h = 8 * getPixelSize();

					SDL_FillRect(SDL_GetVideoSurface(), &rect, 255);

					drawCharacter(x, 192 * getPixelSize() - 8 * getPixelSize(), 0, 0, 0, tmp);

					if (x < 39 * 7 * getPixelSize())
						x += 7 * getPixelSize();
					else
					{
						rect.x = 0;
						rect.y = 192 * getPixelSize() - 8 * getPixelSize();
						rect.w = 280 * getPixelSize();
						rect.h = 8 * getPixelSize();

						SDL_FillRect(SDL_GetVideoSurface(), &rect, 255);

						for (i = 0; i < 39 * getPixelSize() * getPixelSize(); ++i)
						{
							if (buffer[(c - 39) + i] == ' ')
							{
								rect.x = 7 * i;
								rect.y = 192 * getPixelSize() - 8 * getPixelSize();
								rect.w = 7 * getPixelSize();
								rect.h = 8 * getPixelSize();

								SDL_FillRect(SDL_GetVideoSurface(), &rect, 255);
							}
							else
								drawCharacter(7 * getPixelSize() * i, 192 * getPixelSize() - 8 * getPixelSize(), 0, 0, 0, buffer[(c - 39) + i]);
						}
					}

					drawCharacter(x, 192 * getPixelSize() - 8 * getPixelSize(), 0, 0, 0, 0x01);
				}
			}
		}

		SDL_Flip(SDL_GetVideoSurface());
	}
}

static int loadMemoryFunc(void)
{
	int i, size, address, value;

	if (step == 1)
	{
		strcpy(filename, buffer);

		drawString("Enter (A)scii or (B)inary:");

		max = 1;
	}
	else if (step == 2)
	{
		type = buffer[0];

		if (type == 'A' || type == 'a')
		{
			fd = fopen(filename, "r");

			if (!fd)
			{
				fprintf(stderr, "Could not open %s\n", filename);
				return 0;
			}

			step++;
		}
		else if (type == 'B' || type == 'b')
		{
			fd = fopen(filename, "rb");

			if (!fd)
			{
				fprintf(stderr, "Could not open %s\n", filename);
				return 0;
			}

			drawString("Enter starting address:");

			max = 4;
		}
		else
		{
			fprintf(stderr, "Invalid character for mode\n");
			return 0;
		}
	}
								
	if (step == 3)
	{
		if (type == 'A' || type == 'a')
		{
			while (!feof(fd))
			{
				if (!fgets(buffer, 1024, fd))
					continue;

				if (buffer[0] == '/' || buffer[0] == '\n')
					continue;
								
				strncpy(strAddress, buffer, 4);
								
				if (sscanf(strAddress, "%04X", &address) < 1)
					continue;
								
				for (i = 6; i < (int)strlen(buffer); i += 3)
				{
					strncpy(strValue, &buffer[i], 2);
												
					if (sscanf(strValue, "%02X", &value) < 1)
						break;
												
					memWrite((unsigned short)(address + ((i - 6) / 3)), (unsigned char)value);
				}
			}
		}
		else
		{
			if (sscanf(buffer, "%04X", &start) < 1)
			{
				fprintf(stderr, "Invalid address for start\n");
				return 0;
			}
										
			fseek(fd, 0, SEEK_END);
			size = ftell(fd);
			fseek(fd, 0, SEEK_SET);

			for (i = start; i < (start + size); ++i)
				memWrite((unsigned short)i, (unsigned char)fgetc(fd));
		}

		return 0;
	}

	return 1;
}

void loadMemory(void)
{
	max = 1024;

	inputLoop("Enter file to load:", &loadMemoryFunc);
}

static int saveMemoryFunc(void)
{
	int i, j, end;
	unsigned char *fbrut;
	char *strFile;

	if (step == 1)
	{
		strcpy(filename, buffer);

		drawString("Enter (A)scii or (B)inary:");

		max = 1;
	}
	else if (step == 2)
	{
		type = buffer[0];

		if (type == 'A' || type == 'a')
		{
			fd = fopen(filename, "w");

			if (!fd)
			{
				fprintf(stderr, "Could not open %s\n", filename);
				return 0;
			}
		}
		else if (type == 'B' || type == 'b')
		{
			fd = fopen(filename, "wb");

			if (!fd)
			{
				fprintf(stderr, "Could not open %s\n", filename);
				return 0;
			}
		}
		else
			return 0;
									
		drawString("Enter starting address:");

		max = 4;
	}
	else if (step == 3)
	{	
		strncpy(strAddress, buffer, 4);

		if (sscanf(strAddress, "%04X", &start) < 1)
		{
			fprintf(stderr, "Invalid address for start\n");
			return 0;
		}

		drawString("Enter ending address:");
	}
	else if (step == 4)
	{
		strncpy(strAddress, buffer, 4);

		if (sscanf(strAddress, "%04X", &end) < 1)
		{
			fprintf(stderr, "Invalid address for end\n");
			return 0;
		}

		fbrut = dumpMemory((unsigned short)start, (unsigned short)end);

		if (type == 'A' || type == 'a')
		{
			strcpy(buffer, "// Pom1 Save - ");

			strFile = strrchr(filename, '/');

			if (!strFile)
			{
				strFile = strrchr(filename, '\\');

				if (!strFile)
					strFile = filename;
				else
					strFile++;
			}
			else
				strFile++;

			strcat(buffer, strFile);

			strcat(buffer, "\n");

			fputs(buffer, fd);

			j = start;

			for (i = 0; i < (end - start + 1); ++i, ++j)
			{
				if (j % 8 == 0 || j == start)
				{
					strcpy(buffer, "\n");

					sprintf(strAddress, "%04X", j);

					strcat(buffer, strAddress);

					strcat(buffer, ": ");

					fputs(buffer, fd);
				}

				sprintf(strValue, "%02X", fbrut[i]);

				strcpy(buffer, strValue);

				strcat(buffer, " ");

				fputs(buffer, fd);
			}
		}
		else
			fwrite(fbrut, 1, end - start + 1, fd);

		free(fbrut);

		return 0;
	}

	return 1;
}

void saveMemory(void)
{
	max = 1024;

	inputLoop("Enter file to save:", &saveMemoryFunc);
}

static int changePixelSizeFunc(void)
{
	if (buffer[0] == '1' || buffer[0] == '2')
	{
		setPixelSize(buffer[0] & 0x03);

		if (buffer[0] == '1')
			setScanline(0);

		SDL_SetVideoMode(280 * getPixelSize(), 192 * getPixelSize(), 8, SDL_HWSURFACE | SDL_DOUBLEBUF | (getFullScreen() ? SDL_FULLSCREEN : 0));
	}
	else
		fprintf(stderr, "Invalid size for pixel\n");

	return 0;
}

void changePixelSize(void)
{
	max = 1;

	inputLoop("Enter 1 or 2 for pixel size:", &changePixelSizeFunc);
}

static int changeTerminalSpeedFunc(void)
{
	setTerminalSpeed(atoi(buffer));

	return 0;
}

void changeTerminalSpeed(void)
{
	max = 10;

	inputLoop("Enter terminal speed:", &changeTerminalSpeedFunc);
}

static int setIrqBrkVectorFunc(void)
{
	int brkVector;

	if (sscanf(buffer, "%04X", &brkVector) < 1)
		fprintf(stderr, "Invalid address for vector\n");
	else
	{
		memWrite(0xFFFE, (unsigned char)(brkVector & 0xFF));
		memWrite(0xFFFF, (unsigned char)((brkVector / 0x100) & 0xFF));
	}

	return 0;
}

void setIrqBrkVector(void)
{
	max = 4;

	inputLoop("Enter IRQ/BRK vector:", &setIrqBrkVectorFunc);
}
